; You'll need FASM (http://flatassembler.net/) to compile this program.
;
; Turok 2: Seeds of Evil CD Music Patch v2.1
; (c) -=CHE@TER=- 2014-2015,2018
; http://ctpax-cheater.losthost.org
; mailto: _CTPAX_(a)mail(.)ru
;
; Turok 2: Seeds of Evil CD Music Patch v1.x
; (c) -=CHE@TER=- 2007-2014
;
; This is a patch for Turok 2: Seed of Evil game to fix CD music playback under Windows XP and later.
; Latest version always available at:
; http://ctpax-cheater.losthost.org/htmldocs/turok.htm#turok_patch
;
; Should work now even with the protected game executables.
; Because everything patched in the memory.
; But I didn't test it on SecuROM game versions so any feedback are welcome.
;
; version 2.1
; 2018.10.26 - code cleanup, should be Windows 98 compatible now
;
; version 2.0
; 2015.02.10 - part three and reworked code
; 2014.10.29 - part one and two
;
; --- Program comments goes below this line. ---
;
; First of all note that this library name must match the "Video_*.dll*" mask
; so the game can found it and load at startup assume that this was a video driver.

format PE GUI 2.0 DLL

include 'win32a.inc'

struct IMAGEIMPORTDESCRIPTOR
  OriginalFirstThunk dd ?
  TimeDateStamp      dd ?
  ForwarderChain     dd ?
  Name               dd ?
  FirstThunk         dd ?
ends

; MMSystem consts and structs

MCI_PLAY        = 0806h
MCI_STOP        = 0808h
MCI_STATUS      = 0814h
MCI_STATUS_ITEM = 00000100h
; 512 + 13
MCI_MODE_STOP   = 020Dh
; 512 + 14
MCI_MODE_PLAY   = 020Eh
MCI_STATUS_MODE = 00000004h
MCI_WAIT        = 00000002h
MCI_TRACK       = 00000010h
MCI_STATUS_CURRENT_TRACK = 00000008h

struct MCI_STATUS_PARMS
 dwCallback dd ?
   dwReturn dd ?
     dwItem dd ?
    dwTrack dd ?
ends

struct MCI_PLAY_PARMS
  dwCallback dd ?
      dwFrom dd ?
        dwTo dd ?
ends

entry DllEntryPoint

section '.text' readable executable code

; This proc must be extremly small:
; 1) Because only short jumps allowed (07Fh or less bytes) -
;    remember that this is an injected code, so no relocs.
; 2) To keep compiled file at 2Kb in size.
proc stub_mciSendCommandA mciId, uMessage, dwParam1, dwParam2
@addr_MSCA:
  ; this value will be replaced to original mciSendCommandA addr
  mov eax, 12345678h
  push ebx
  push esi
  push edi
  ; save orig addr
  mov ebx, eax
  ; save Param2 addr
  mov edi, [dwParam2]
  ; call original proc
  push edi
  push [dwParam1]
  push [uMessage]
  push [mciId]
  call eax
  ; save orig error code
  push eax
;  ; got error?
;  test eax, eax
;  jnz @mci_quit
  ; Param2 empty?
  test edi, edi
  jz @mci_quit
  ; get addr of prvtrack
  call @get_addr
@get_addr:
  pop esi
  add esi, prvtrack - @get_addr
  ; test if this was a play command
  cmp [uMessage], MCI_PLAY
  jnz @status
  ; save track
  mov eax, [edi + MCI_PLAY_PARMS.dwFrom]
  mov [esi], eax
@status:
  ; test if this was a status command
  cmp [uMessage], MCI_STATUS
  jnz @mci_quit
  ; test if this was an item subcommand
  test [dwParam1], MCI_STATUS_ITEM
  jz @mci_quit
  ; test if this was a status mode param
  cmp [edi + MCI_STATUS_PARMS.dwItem], MCI_STATUS_MODE
  jnz @mci_quit
  ; test if track still playing
  cmp [edi + MCI_STATUS_PARMS.dwReturn], MCI_MODE_PLAY
  jnz @mci_quit
  ; still playing - check current track
  mov [edi + MCI_STATUS_PARMS.dwItem], MCI_STATUS_CURRENT_TRACK
  push edi
  push MCI_WAIT or MCI_STATUS_ITEM or MCI_TRACK
  push MCI_STATUS
  push [mciId]
  call ebx
;  ; got error?[1]
;  test eax, eax
  ; save result
  mov eax, [edi + MCI_STATUS_PARMS.dwReturn]
  ; restore struct
  mov [edi + MCI_STATUS_PARMS.dwItem], MCI_STATUS_MODE
  mov [edi + MCI_STATUS_PARMS.dwReturn], MCI_MODE_PLAY
;  ; got error?[2]
;  jnz @mci_quit
  ; compare previous and current track
  cmp [esi], eax
  jz @mci_quit
  ; track changed - set mode to stop
  mov [edi + MCI_STATUS_PARMS.dwReturn], MCI_MODE_STOP
  ; stop track
  push edi
  push MCI_WAIT
  push MCI_STOP
  push [mciId]
  call ebx
  @mci_quit:
  pop eax ; restore original error code
  pop edi
  pop esi
  pop ebx
  ret
; previous track number
prvtrack dd 0
endp
; proc size must be here - do not move it
_size_MSCA = ($ - stub_mciSendCommandA)

proc stub_GetCurrentThreadId
@addr_GCTI:
  ; this value will be replaced to main thread id
  mov eax, 12345678h
  ret
endp
; proc size must be here - do not move it
_size_GCTI = ($ - stub_GetCurrentThreadId)

proc DllEntryPoint hinstDLL, fdwReason, lpvReserved
  xor eax, eax
  inc eax
  ret
endp

; helper proc
proc PatchImport ModName, ProcAddr, StubAddr, StubSize, OfsValue, PutValue
  push ebx ; *
  push esi ; *
  push edi ; *
  push ecx
  ; allocate memory for stub-proc
  invoke VirtualAlloc, NULL, [StubSize], MEM_COMMIT, PAGE_EXECUTE_READWRITE
  ; copy proc data
  mov esi, [StubAddr]
  mov edi, eax
  mov ecx, [StubSize]
  cld
  rep movsb
  ; save original pointer
  mov esi, eax
  ; put value to the stub proc
  mov ebx, [PutValue]
  mov eax, [OfsValue]
  mov [esi + eax], ebx
  ; now parse import
  invoke GetModuleHandleA, [ModName]
  mov ebx, eax
  add eax, 3Ch ; PE header offset
  mov eax, [eax]
  add eax, ebx ; PE\0\0
  add eax, 80h ; PEHeader.OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IMPORT].VirtualAddress
  mov eax, [eax]
  add eax, ebx ; Import Table
  ; save old func addr
  mov ecx, [ProcAddr]
  ; walk on the import table
@loopname:
  ; name empty? (end of the table)
  cmp dword [eax + IMAGEIMPORTDESCRIPTOR.Name], 0
  jz @quit
    mov edi, ebx
    add edi, [eax + IMAGEIMPORTDESCRIPTOR.FirstThunk]
    ; for each addr
    @loopaddr:
      ; last addr? (end of library)
      cmp dword [edi], 0
      jz @nextname
      ; got the addr to patch?
      cmp [edi], ecx
      jnz @nextaddr
      ; yes - replace proc with stub
      push eax ; lpflOldProtect
      mov eax, esp
      invoke VirtualProtect, edi, 4, PAGE_EXECUTE_READWRITE, eax ; change permission
      mov [edi], esi ; patched!
      mov eax, esp
      invoke VirtualProtect, edi, 4, [eax], eax ; restore permission
      pop eax ; lpflOldProtect
      jmp @quit
    @nextaddr:
      ; go to next addr
      add edi, 4
      jmp @loopaddr
@nextname:
  ; go to next import library
  add eax, 14h ; sizeof IMAGEIMPORTDESCRIPTOR
  jmp @loopname
@quit:

  pop ecx
  pop edi ; *
  pop esi ; *
  pop ebx ; *
  ret
endp

proc GFXDLL_GetDriverInfo
  push ebx ; *
  push esi ; *
  push edi ; *
  push ecx

  ; [Part One]
  ; Apply uni-processor patch.
  ; This will resolve invisible textures and objects
  ; and fixes frequent game crashes.
  invoke GetCurrentProcess
  mov ebx, eax
  ; prc_mask
  push eax
  mov edi, esp
  ; sys_mask
  push eax
  mov esi, esp
  invoke GetProcessAffinityMask, ebx, edi, esi
  pop eax ; sys_mask
  pop eax ; prc_mask
  ; find working core
  ; esi = 1
  xor esi, esi
  inc esi
@loopmask:
  test eax, esi
  jnz @donemask
  shl esi, 1
  jnz @loopmask
  ; just in case - use first core
  inc esi
@donemask:
  invoke SetProcessAffinityMask, ebx, esi

  ; [Part Two]
  ; Patch WINMM.DLL GetCurrentThreadId() import.
  ; This code fix Windows XP and above issue
  ; when mciSendCommandA() won't work when
  ; called from the different threads.
  ; GFXDLL_GetDriverInfo() called from the main
  ; Turok2 thread after mci-handle obtained,
  ; so replace GetCurrentThreadId() with the code
  ; which always return main thread id and this
  ; issue will be solved.
  mov ebx, [GetCurrentThreadId]
  call ebx
  ; patch import for the winmm library
  push eax
  push @addr_GCTI-stub_GetCurrentThreadId+1
  push _size_GCTI
  push stub_GetCurrentThreadId
  push ebx
  push _winmm
  call PatchImport

  ; [Part Three]
  ; Patch TUROK2.EXE mciSendCommandA import.
  ; This code fix Windows Vista and above issue
  ; when mciSendCommandA() still return MCI_MODE_PLAY
  ; for the track that already stopped,
  ; so the track will never repeat again
  ; because the game thinks that it's still played.
  invoke GetModuleHandleA, _winmm
  invoke GetProcAddress, eax, _mscap
  ; patch import for the game executable
  push eax
  push @addr_MSCA-stub_mciSendCommandA+1
  push _size_MSCA
  push stub_mciSendCommandA
  push eax
  push NULL
  call PatchImport

  pop ecx
  pop edi ; *
  pop esi ; *
  pop ebx ; *
  ; return 0 so the Turok2 thinks that
  ; the driver initialization failed
  ; and didn't show this file
  ; in the display driver list
  ; (because this is not a video driver)
  xor eax, eax
  ret
endp

_winmm db 'WINMM.DLL',0
_mscap db 'mciSendCommandA',0

section '.rdata' data readable

data import
  library kernel32, 'KERNEL32.dll'
  import kernel32,\
    GetProcAddress, 'GetProcAddress',\
    GetCurrentThreadId, 'GetCurrentThreadId',\
    GetCurrentProcess, 'GetCurrentProcess',\
    GetModuleHandleA, 'GetModuleHandleA',\
    VirtualProtect, 'VirtualProtect',\
    VirtualAlloc, 'VirtualAlloc',\
    GetProcessAffinityMask, 'GetProcessAffinityMask',\
    SetProcessAffinityMask, 'SetProcessAffinityMask'
end data

data export
  export 'Video_MM.dll', GFXDLL_GetDriverInfo, 'GFXDLL_GetDriverInfo'
end data

section '.reloc' fixups data readable discardable
